# -*- coding: utf-8 -*-
"""
Created on Tue Nov  8 11:36:34 2022

@author: david
"""

from core_tools.data.ds.data_set import load_by_id, load_by_uuid
import numpy as np
import matplotlib.pyplot as plt

#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows

uuid = [1675365320550255110,
        1675369717362255110,
        1675374195146255110,
        1675378711123255110,
        1675383138872255110,
        1675387561679255110,
        1675392196251255110,
        1675396858947255110,
        1675401354598255110,
        1675406104186255110,
        1675410589185255110,
        1675415123588255110]

P0 = [[2.357,1690.63],
      [2.140,1701.03],
      [2.140,1711.42],
      [2.090,1721.95],
      [2.331,1732.10],
      [1.807,1741.65],
      [1.737,1751.68],
      [1.807,1761.90],
      [1.779,1771.86],
      [1.765,1782.19]]

P1 = [[-3.736,1678,00],
      [-3.737,1688.71],
      [-3.687,1699.08],
      [-3.659,1709.75],
      [-3.468,1720.16],
      [-3.093,1730.39],
      [-2.704,1741.36],
      [-2.414,1751.18],
      [-2.810,1761.28],
      [-2.350,1772.02]]

P2 = [[-2.308,1687.97],
      [-2.075,1699.03],
      [-2.216,1709.56],
      [-2.096,1720.78],
      [-2.075,1730.55],
      [-1.820,1741.18],
      [-1.721,1750.41],
      [-1.566,1761.09],
      [-1.566,1771.48],
      [-1.424,1782.07]]

P3 = [[3.243,1683.56],
      [2.932,1694.05],
      [2.691,1704.46],
      [2.359,1714.13],
      [2.041,1724.21],
      [1.567,1734.44],
      [1.977,1743.70],
      [1.687,1754.28],
      [1.970,1763.74],
      [1.178,1774.40]]

peak = 9

uuid = np.array(uuid)

ds = load_by_uuid(int(uuid[peak]))

# get x, y, and z data:
x = ds.m1.x()
y = ds.m1.y()
z = ds.m1() #or if you like you can also call m1.z()

plt.pcolormesh(y,x,z*1e9)

# aux = np.gradient(z,axis=1)
# plt.figure()
# plt.pcolormesh(y,x,aux)

plt.scatter(P0[peak][0]*10,P0[peak][1], color = 'r')
plt.scatter(P1[peak][0]*10,P1[peak][1], color = 'r')
plt.scatter(P2[peak][0]*10,P2[peak][1], color = 'r')
plt.scatter(P3[peak][0]*10,P3[peak][1], color = 'r')

plt.plot([P0[peak][0]*10,P1[peak][0]*10], [P0[peak][1],P1[peak][1]], color = 'r')
plt.plot([P2[peak][0]*10,P3[peak][0]*10], [P2[peak][1],P3[peak][1]], color = 'r')
plt.ylabel('VP (mV)')
plt.xlabel('V$_{SD}$ (mV)')
# plt.colorbar()

aux = np.gradient(z,axis=1)
plt.figure()
plt.pcolormesh(y,x,aux)

plt.scatter(P0[peak][0]*10,P0[peak][1], color = 'r')
plt.scatter(P1[peak][0]*10,P1[peak][1], color = 'r')
plt.scatter(P2[peak][0]*10,P2[peak][1], color = 'r')
plt.scatter(P3[peak][0]*10,P3[peak][1], color = 'r')

plt.plot([P0[peak][0]*10,P1[peak][0]*10], [P0[peak][1],P1[peak][1]], color = 'r')
plt.plot([P2[peak][0]*10,P3[peak][0]*10], [P2[peak][1],P3[peak][1]], color = 'r')

plt.ylabel('VP (mV)')
plt.xlabel('V$_{SD}$ (mV)')
# plt.colorbar(label = 'dI/dV')

#Calculate lever arm
ms = (P0[peak][0]-P1[peak][0])/(P0[peak][1]-P1[peak][1])
md = (P2[peak][0]-P3[peak][0])/(P2[peak][1]-P3[peak][1])

a = abs(ms*md/(ms-md))
print(a)

#%% Lever arm peak 1758

V0 = np.array([1763.28])
V1 = np.array([1751.84])
V2 = np.array([1761.83])
V3 = np.array([1753.76])

Vsd0 = np.array([2.270])
Vsd1 = np.array([-2.666])
Vsd2 = np.array([-1.580])
Vsd3 = np.array([1.481])

ms = (Vsd0-Vsd1)/(V0-V1)
md = (Vsd2-Vsd3)/(V2-V3)

a = abs(ms*md/(ms-md))
print(a)

#%% Lever arm Uri data 6d2s

V0 = np.array([1247.5])
V1 = np.array([1235])
V2 = np.array([1242.5])
V3 = np.array([1240])

Vsd0 = np.array([1.4])
Vsd1 = np.array([-1.6])
Vsd2 = np.array([-1.2])
Vsd3 = np.array([1.4])

ms = (Vsd0-Vsd1)/(V0-V1)
md = (Vsd2-Vsd3)/(V2-V3)

a = abs(ms*md/(ms-md))















